/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.Profile;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPPeer;
import jade.imtp.leap.JICP.JICPSConnection;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class JICPSPeer
extends JICPPeer {
    protected static Logger myLogger = Logger.getMyLogger((class$jade$imtp$leap$JICP$JICPSPeer == null ? (class$jade$imtp$leap$JICP$JICPSPeer = JICPSPeer.class$("jade.imtp.leap.JICP.JICPSPeer")) : class$jade$imtp$leap$JICP$JICPSPeer).getName());
    private SSLContext ctx = null;
    private boolean useSSLAuth = false;
    static /* synthetic */ Class class$jade$imtp$leap$JICP$JICPSPeer;

    public TransportAddress activate(ICP.Listener l, String peerID, Profile p) throws ICPException {
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "About to activate JICP peer.");
        }
        this.ctx = this.createContext();
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "activate() context created ctx=" + this.ctx);
        }
        TransportAddress ta = super.activate(l, peerID, p);
        if (myLogger.isLoggable(Logger.INFO)) {
            myLogger.log(Logger.INFO, "JICP Secure Peer activated. (auth=" + this.getUseSSLAuth() + ", ta=" + ta + ")");
        }
        return ta;
    }

    public ConnectionFactory getConnectionFactory() {
        return new ConnectionFactory(){

            public Connection createConnection(Socket s) {
                return new JICPSConnection(s);
            }

            public Connection createConnection(TransportAddress ta) throws IOException {
                return new JICPSConnection(ta, JICPSPeer.this.getUseSSLAuth());
            }
        };
    }

    protected ServerSocket getServerSocket(String host, int port, boolean changePortIfBusy) throws ICPException {
        ServerSocket sss = null;
        if (this.getUseSSLAuth()) {
            sss = this.getServerSocketWithAuth(host, port, changePortIfBusy);
            if (myLogger.isLoggable(Logger.FINE)) {
                myLogger.log(Logger.FINE, "Creating JICPSPeer with mutual Authentication.");
            }
        } else {
            sss = this.getServerSocketNoAuth(host, port, changePortIfBusy);
            if (myLogger.isLoggable(Logger.WARNING)) {
                myLogger.log(Logger.WARNING, "Creating JICPSPeer with NO-AUTHENTICATION (only confidentiality).");
            }
        }
        return sss;
    }

    private ServerSocket getServerSocketWithAuth(String host, int port, boolean changePortIfBusy) throws ICPException {
        SSLServerSocket sss;
        block9: {
            if (this.ctx == null) {
                this.ctx = JICPSPeer.createContextWithAuth();
            }
            sss = null;
            try {
                SSLServerSocketFactory serverSocketFactory = this.ctx.getServerSocketFactory();
                try {
                    sss = (SSLServerSocket)serverSocketFactory.createServerSocket(port);
                }
                catch (IOException ioe) {
                    if (changePortIfBusy) {
                        try {
                            sss = (SSLServerSocket)serverSocketFactory.createServerSocket(0);
                            break block9;
                        }
                        catch (IOException ioe2) {
                            throw new ICPException("Problems initializing server socket. No free port found.", ioe2);
                        }
                    }
                    throw new ICPException("I/O error opening server socket on port " + port, ioe);
                }
            }
            catch (Exception e) {
                throw new ICPException("Error creating SSLServerSocketFactory.", e);
            }
        }
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, JICPSPeer.getChiperDebugString(sss));
        }
        return sss;
    }

    private static String getChiperDebugString(SSLServerSocket sss) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n--EnabledProtocols:\n");
        String[] prot = sss.getEnabledProtocols();
        int i = 0;
        while (i < prot.length) {
            sb.append("  " + prot[i]);
            ++i;
        }
        sb.append("\n--EnabledCipherSuites:\n");
        String[] suite = sss.getEnabledCipherSuites();
        int i2 = 0;
        while (i2 < suite.length) {
            sb.append("  " + suite[i2]);
            ++i2;
        }
        sb.append("\n--SupportedCipherSuites\n");
        String[] supported_suite = sss.getSupportedCipherSuites();
        int i3 = 0;
        while (i3 < supported_suite.length) {
            sb.append("  " + supported_suite[i3]);
            ++i3;
        }
        sb.append("\n--\n");
        return sb.toString();
    }

    private ServerSocket getServerSocketNoAuth(String host, int port, boolean changePortIfBusy) throws ICPException {
        SSLServerSocket sss;
        block10: {
            if (this.ctx == null) {
                this.ctx = this.createContextNoAuth();
            }
            sss = null;
            try {
                SSLServerSocketFactory ssf = this.ctx.getServerSocketFactory();
                try {
                    sss = (SSLServerSocket)ssf.createServerSocket(port);
                }
                catch (IOException ioe) {
                    if (changePortIfBusy) {
                        try {
                            sss = (SSLServerSocket)ssf.createServerSocket(0);
                            break block10;
                        }
                        catch (IOException ioe2) {
                            throw new ICPException("Problems initializing server socket. No free port found.", ioe2);
                        }
                    }
                    throw new ICPException("I/O error opening server socket on port " + port, ioe);
                }
            }
            catch (Exception e) {
                throw new ICPException("Error creating SSLServerSocketFactory.", e);
            }
        }
        try {
            sss.setEnabledCipherSuites(new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"});
            String[] ecs = sss.getEnabledCipherSuites();
        }
        catch (Exception e) {
            throw new ICPException("Error enabling cypher suites.", e);
        }
        return sss;
    }

    private boolean getUseSSLAuth() {
        return this.useSSLAuth;
    }

    private void setUseSSLAuth(boolean b) {
        this.useSSLAuth = b;
    }

    private SSLContext createContext() throws ICPException {
        SSLContext ctx = null;
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            System.setProperty("javax.net.ssl.keyStore", "keystore");
        }
        if (System.getProperty("javax.net.ssl.keyStorePassword") == null) {
            System.setProperty("javax.net.ssl.keyStorePassword", "passphrase");
        }
        if (System.getProperty("javax.net.ssl.trustStore") == null) {
            System.setProperty("javax.net.ssl.trustStore", "truststore");
        }
        boolean storesPresent = new File(System.getProperty("javax.net.ssl.keyStore")).canRead() && new File(System.getProperty("javax.net.ssl.trustStore")).canRead();
        boolean isAbleToOpenStores = true;
        if (storesPresent && isAbleToOpenStores) {
            this.setUseSSLAuth(true);
        }
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "keyStore and trustStore found!");
        }
        ctx = this.getUseSSLAuth() ? JICPSPeer.createContextWithAuth() : this.createContextNoAuth();
        return ctx;
    }

    private SSLContext createContextNoAuth() throws ICPException {
        SSLContext ctx = null;
        if (ctx == null) {
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(null, null, null);
            }
            catch (Exception e) {
                throw new ICPException("Error creating SSLContext.", e);
            }
        }
        return ctx;
    }

    static SSLContext createContextWithAuth() throws ICPException {
        SSLContext ctx = null;
        try {
            char[] passphrase = System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(System.getProperty("javax.net.ssl.keyStore")), passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            throw new ICPException("Error creating SSLContext.", e);
        }
        return ctx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

